Financing_ShopConfigScreen = {}
local modDirectory = g_currentModDirectory

function Financing_ShopConfigScreen:onClickFinance()

    local currentMission = g_currentMission

    if self.vehicle ~= nil or not self.storeItem.allowLeasing then
        return
    end

    local farmId = g_localPlayer.farmId
    local farm

    if farmId ~= nil then farm = g_farmManager:getFarmById(farmId) end
    
    if farm == nil then return end

    local farmMoney = farm.money

    local enoughMoney = self.totalPrice / 12 <= farmMoney
    local enoughSlots = currentMission.slotSystem:hasEnoughSlots(self.storeItem)

    g_inputBinding:setShowMouseCursor(true)

    if not enoughMoney then
        self:playSample(GuiSoundPlayer.SOUND_SAMPLES.ERROR)
        local dialog = g_gui:showDialog("InfoDialog")
        if dialog.target ~= nil then dialog.target:setText(g_i18n:getText("financing_notEnoughMoney")) end
    elseif not enoughSlots then
        self:playSample(GuiSoundPlayer.SOUND_SAMPLES.ERROR)
        local dialog = g_gui:showDialog("InfoDialog")
        if dialog.target ~= nil then dialog.target:setText(g_i18n:getText(ShopConfigScreen.L10N_SYMBOL.TOO_FEW_SLOTS)) end
    else
        self:playSample(GuiSoundPlayer.SOUND_SAMPLES.CLICK)
        local text = string.format(g_i18n:getText("shop_doYouWantToFinance"), g_i18n:formatMoney((self.totalPrice * 1.02) / 6, 2, true, true), g_i18n:formatMoney((self.totalPrice * 1.05) / 12, 2, true, true), g_i18n:formatMoney((self.totalPrice * 1.1) / 24, 2, true, true))

        local dialog = g_gui:showDialog("OptionDialog")
        local options = {
            [1] = "6 Months @ 2%",
            [2] = "1 Year @ 5%",
            [3] = "2 Years @ 10%"
        }
        local callback = function(item)
            self:onYesFinance(item)
        end
        if dialog ~= nil then
            dialog.target:setTitle("Financing")
            dialog.target:setText(text)
            dialog.target:setOptions(options)
            dialog.target:setCallback(callback)
            dialog.target:setButtonTexts("Confirm", "Cancel")
        end
    end

end

ShopConfigScreen.onClickFinance = Financing_ShopConfigScreen.onClickFinance

function Financing_ShopConfigScreen:onYesFinance(item)

    if item == 0 then
        g_gui:closeAllDialogs()
        return
    end

    local length = 6
    local interest = 1.02
    if item == 2 then
        interest = 1.05
        length = 12
    end
    if item == 3 then
        interest = 1.1
        length = 24
    end

    --local playerSystem = g_currentMission.playerSystem
    --local playerId = g_currentMission.playerUserId
    local farmId = g_localPlayer.farmId

    local data = BuyVehicleData.new()
    data:setFinancingLength(length)
    data:setStoreItem(self.storeItem)
    data:setConfigurations(self.configurations)
    data:setOwnerFarmId(farmId)
    data:setPrice((self.totalPrice * interest) / length)
    data:setFinancingInterest(interest)
    data:setLicensePlateData(self.licensePlateData)

    g_client:getServerConnection():sendEvent(BuyVehicleEvent.new(data))

end

ShopConfigScreen.onYesFinance = Financing_ShopConfigScreen.onYesFinance

function Financing_ShopConfigScreen:loadMap()

    --g_gui:loadGui(modDirectory .. "xml/ShopConfigScreen.xml", "ShopConfigScreen", g_shopConfigScreen)

    --local statsObj = nil
    --for name, frame in pairs(g_gui.frames) do

        --if name == "ingameMenuGameStats" then statsObj = frame end

    --end

    --g_gui:loadGui(modDirectory .. "xml/InGameMenuStatisticsFrame.xml", "ingameMenuGameStats", statsObj.parent, true)

    --g_shopConfigScreen.elements[1] = g_shopConfigScreen.elements[2]
    --table.remove(g_shopConfigScreen.elements, 2)

end

--addModEventListener(Financing_ShopConfigScreen)