ProductionLeasingEvent = {}

local ProductionLeasingEvent_mt = Class(ProductionLeasingEvent, Event)
InitEventClass(ProductionLeasingEvent, "ProductionLeasingEvent")

function ProductionLeasingEvent.emptyNew()
    local self = Event.new(ProductionLeasingEvent_mt)
    return self
end

function ProductionLeasingEvent.new(PlaceableToLease, FarmIdToLease, Enable)
    local self = ProductionLeasingEvent.emptyNew()
    self.PlaceableToLease = PlaceableToLease
    self.FarmIdToLease = FarmIdToLease
    self.Enable = Enable

    return self
end

function ProductionLeasingEvent:readStream(streamId, connection)
    self.PlaceableToLease = NetworkUtil.readNodeObject(streamId)
    self.FarmIdToLease = streamReadUInt8(streamId)
    self.Enable = streamReadBool(streamId)

    self:run(connection)
end

function ProductionLeasingEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.PlaceableToLease)
    streamWriteUInt8(streamId, self.FarmIdToLease)
	streamWriteBool(streamId, self.Enable)
end

function ProductionLeasingEvent:run(connection)
    if not connection:getIsServer() then

        if self.Enable then
            self.PlaceableToLease:setOwnerFarmId(self.FarmIdToLease, false);
            self.PlaceableToLease:setName(ProductionPointLeasing.LeaseTitlePrefix.. self.PlaceableToLease:getName(), false);
            g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, self.FarmIdToLease);
        else
            self.PlaceableToLease:setName(string.sub(self.PlaceableToLease:getName(), #ProductionPointLeasing.LeaseTitlePrefix + 1), false);	
            self.PlaceableToLease:setOwnerFarmId(0, false);
            g_messageCenter:publish(MessageType.FARM_PROPERTY_CHANGED, self.FarmIdToLease);
        end
    end
end