tcGui = {};

local tcGui_mt = Class(tcGui, MessageDialog);

function tcGui:new(target, custom_mt)
    local self = MessageDialog.new(target, custom_mt or tcGui_mt);
    self.returnScreenName = "";
    return self;	
end;

function tcGui:onGuiSetupFinished()
	tcGui:superClass().onGuiSetupFinished(self)
end
function tcGui:onCreate()
	--tcGui:superClass().onCreate(self)
end

function tcGui:onOpen()
    tcGui:superClass().onOpen(self);
	FocusManager:setFocus(self.backButton);
end;

function tcGui:onClose()
    tcGui:superClass().onClose(self);
end;

function tcGui:onClickBack()
    tcGui:superClass().onClickBack(self)
	self:onClose();
	--TowingChainHook:guiClosed()
end;

function tcGui:onClickOk()
    tcGui:superClass().onClickOk(self)
	TowingChainHook:settingsFromGui(self.manualAttach:getState(), self.showHelp:getState(), self.showIds:getState(), self.IdsDistanceView:getState(), self.chainDistanceView:getState(), self.steeringMode:getState(), self.autoOffVehicle:getState());
    self:onClickBack()
end;

function tcGui:onIngameMenuHelpTextChanged(element)
end;

function tcGui:onCreateTcGuiHeader(element)
	element:setTextInternal(g_i18n:getText('gui_tc_Setting'), false, true)
end;

function tcGui:onCreateManualAttach(element)
    self.manualAttach = element
	--element.labelElement.text = g_i18n:getText('gui_tc_manualAttach');
	--element.toolTipText = g_i18n:getText('gui_tc_manualAttachToolTip');
    local values = {}
    for i = 1, #TowingChainHook.booleansTexts, 1 do
        values[i] = TowingChainHook.booleansTexts[i]
    end
    element:setTexts(values)
end
function tcGui:setManualAttach(index)
    self.manualAttach:setState(index, false)
end

function tcGui:onCreateShowHelp(element)
    self.showHelp = element
	--element.labelElement.text = g_i18n:getText('gui_tc_showHelp');
	--element.toolTipText = g_i18n:getText('gui_tc_showHelpToolTip');
    local values = {}
    for i = 1, #TowingChainHook.booleansTexts, 1 do
        values[i] = TowingChainHook.booleansTexts[i]
    end
    element:setTexts(values)
end
function tcGui:setShowHelp(index)
    self.showHelp:setState(index, false)
end

function tcGui:onCreateShowIds(element)
    self.showIds = element
	--element.labelElement.text = g_i18n:getText('gui_tc_showIds');
	--element.toolTipText = g_i18n:getText('gui_tc_showIdsToolTip');
    local values = {}
    for i = 1, #TowingChainHook.booleansTexts, 1 do
        values[i] = TowingChainHook.booleansTexts[i]
    end	
	element:setTexts(values)
end
function tcGui:setShowIds(index)
    self.showIds:setState(index, false)
end

function tcGui:onCreateIdsDistanceView(element)
    self.IdsDistanceView = element
	--element.labelElement.text = g_i18n:getText('gui_tc_IdsDistanceView');
	--element.toolTipText = g_i18n:getText('gui_tc_IdsDistanceViewToolTip');
    local values = {}
    for i = 1, #TowingChainHook.IdsDistanceViewsTexts, 1 do
        values[i] = TowingChainHook.IdsDistanceViewsTexts[i]
    end
    element:setTexts(values)
end;
function tcGui:setIdsDistanceView(index)
    self.IdsDistanceView:setState(index, false)
end;

function tcGui:onCreateChainDistanceView(element)
    self.chainDistanceView = element
	--element.labelElement.text = g_i18n:getText('gui_tc_chainDistanceView');
	--element.toolTipText = g_i18n:getText('gui_tc_chainDistanceViewToolTip');
    local values = {}
    for i = 1, #TowingChainHook.chainDistanceViewsTexts, 1 do
        values[i] = TowingChainHook.chainDistanceViewsTexts[i]
    end
    element:setTexts(values)
end;
function tcGui:setChainDistanceView(index)
    self.chainDistanceView:setState(index, false)
end

function tcGui:onCreateSteeringMode(element)
    self.steeringMode = element
	--element.labelElement.text = g_i18n:getText('gui_tc_steeringMode');
	--element.toolTipText = g_i18n:getText('gui_tc_steeringModeToolTip');
	local values = {}
    for i = 1, #TowingChainHook.steeringModesTexts, 1 do
        values[i] = TowingChainHook.steeringModesTexts[i]
    end
    element:setTexts(values)
end;
function tcGui:setSteeringMode(index)
    self.steeringMode:setState(index, false)
end;

function tcGui:onCreateAutoOffVehicle(element)
    self.autoOffVehicle = element
	--element.labelElement.text = g_i18n:getText('gui_tc_autoOffVehicle');
	--element.toolTipText = g_i18n:getText('gui_tc_autoOffVehicleToolTip');
    local values = {}
    for i = 1, #TowingChainHook.booleansTexts, 1 do
        values[i] = TowingChainHook.booleansTexts[i]
    end
    element:setTexts(values)
end;
function tcGui:setAutoOffVehicle(index)
    self.autoOffVehicle:setState(index, false)
end;
function tcGui:onClickShowIds(element)
	self.IdsDistanceView:setDisabled(not TowingChainHook.booleans[self.showIds:getState()])
end
function tcGui:onClickResetButton()
    TowingChainHook:settingsResetGui()
end;